
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Nov 30 10:19:22 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief AES ATP test vectors
   *
   *  \version CRYS_Ext_ATP_TST_AES_Acceptance_test_vectors.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* disabling pc lint warning regarding to few initializers in braces :
   Too few initializers for aggregate 'unknown-name' */
/*lint --e{785} */   
   
/***************************
 * File Name:                                                           
 *  CRYS_Ext_ATP_AES_Acceptance_test_vectors.c       
 *
 * Description:                                                                 
 *  This file contatind the test vectors used for external application AES Acceptance tests                              
 *
 **************************/
 /***** Include Files ******/
#include "CRYS_Ext_ATP_AES_Acceptance.h"

/******** Defines ********/
/******** Enums **********/
/******** Typedefs *********/
/******** Global Data ********/
/***** Private function prototype ******/
/****** **** Public Functions *****/
/******** Private Functions ******/
/*****************************/
/************** External Key Vectors  ********/
/*****************************/
TST_Ext_AES_TestDataStruct SEP_AES_Acceptance_TestData[] =
{
	{
		{"Acceptance test - AES/ECB/256Key/1536ByteData "},
            /*TST_Key*/     
        {0xc0,0xd1,0x93,0xe2,0xe4,0xfc,0x89,0xd5,0xc8,0x5a,0x94,0x83,0x8f,0xcd,0x1d,0x81,
        0x0e,0x2d,0xad,0x02,0x38,0xea,0x02,0x9c,0xd9,0xf3,0x63,0x4f,0x88,0xd6,0x30,0xc3},
        CRYS_AES_Key256BitSize,
        /*TST_IvCounter*/       
        {0},
        /*TST_input_data*/
        {0x47,0x16,0xe6,0x72,0xc8,0x03,0x08,0x89,0x4a,0x6e,0x3c,0xcf,0x0d,0x9e,0x79,0xf1,
        0x5f,0xc1,0x08,0xa1,0x79,0x3a,0x8b,0x8b,0xa4,0x3c,0x3d,0x8b,0xa0,0x98,0x7b,0x1d,
        0x45,0xd3,0x84,0x15,0x6b,0x7c,0x7d,0x90,0x08,0xbc,0xb8,0x2a,0x98,0x2f,0x35,0x71,
        0xc2,0xf2,0x69,0x9a,0x38,0xfe,0x3f,0x73,0xdf,0xb4,0x5d,0x99,0x30,0xb8,0xa8,0xeb,
        0xde,0x03,0x0a,0x3e,0xb8,0x34,0x73,0x53,0xd2,0x27,0x1d,0x06,0xdf,0xc9,0x15,0xc7,
        0xe2,0x2b,0xf7,0x4e,0x06,0xd5,0xf8,0x8b,0xc9,0x5c,0x2a,0xdc,0x60,0x37,0xfc,0x83,
        0x57,0xce,0x00,0x57,0x79,0xd4,0xf2,0xb9,0xef,0xd7,0xf5,0xca,0xac,0x15,0x1f,0xdc,
        0x08,0x92,0x38,0x26,0xaa,0x67,0xbf,0xbb,0xac,0x5d,0x2e,0xbd,0xfa,0xba,0x80,0xcd,
        0xfb,0x5b,0xef,0xc7,0x74,0x03,0x02,0xac,0xa9,0xf3,0xc7,0xe0,0xc5,0xbb,0x5d,0x96,
        0x7b,0x4f,0xb6,0x88,0xee,0x5d,0x9b,0xeb,0xce,0xde,0xf1,0xa2,0xc4,0xec,0x3a,0xb2,
        0x11,0xd3,0x5f,0xf6,0x72,0x6a,0xac,0x14,0x46,0xa4,0x1c,0xaf,0xf2,0x62,0xd7,0xde,
        0x85,0x8b,0xf9,0xdd,0x98,0x5f,0x95,0x03,0x79,0x08,0xfa,0xf4,0x88,0x72,0x34,0x18,
        0xe0,0x5d,0xd6,0x4c,0x3a,0xb1,0xf7,0xd7,0x0f,0x11,0x7b,0x9f,0xfd,0xb2,0x94,0x9d,
        0x6c,0x6e,0x87,0x8e,0x71,0x14,0xb4,0xeb,0xf3,0x03,0xd1,0x1c,0x0c,0xf7,0x76,0xe9,
        0xb1,0x22,0xde,0x31,0x96,0x7f,0xec,0xde,0x4c,0x63,0x6c,0x18,0xac,0x55,0x9c,0xb9,
        0x79,0x1f,0xea,0x01,0x41,0x25,0x00,0x8c,0x84,0xf6,0xfe,0x80,0x19,0x21,0x06,0x0b,
        0xcc,0x4a,0xfe,0x0d,0x4c,0x7c,0x91,0x11,0x45,0xc1,0x77,0x82,0xc9,0xf0,0xf7,0x1c,
        0xf4,0xc7,0xaa,0xa0,0xd0,0x39,0x81,0xcc,0x76,0x09,0x09,0x8a,0x76,0x98,0xee,0x68,
        0x79,0xfc,0xbf,0x48,0x25,0x51,0xf0,0x58,0x41,0x54,0x25,0x45,0x1a,0x2e,0xae,0xac,
        0x25,0x8d,0x4d,0xd2,0xe5,0xf9,0x40,0x94,0x0f,0x66,0x7b,0xa1,0xed,0x05,0x36,0xe6,
        0x00,0x60,0xa7,0x4a,0xe9,0xa6,0x11,0x9c,0x8a,0x43,0xfd,0xc9,0x68,0xb4,0xc7,0x53,
        0x53,0x9a,0x5d,0xfe,0x4a,0x0d,0x44,0xcd,0x99,0x32,0xdc,0x2c,0x44,0x10,0xe4,0x6f,
        0xa8,0x9f,0x40,0x7b,0x60,0x22,0xfa,0xc3,0x66,0xb7,0x88,0x77,0x7a,0x2d,0x4d,0xf7,
        0xc8,0x15,0x62,0x8e,0xc5,0x1c,0x95,0x5d,0x5a,0x98,0xb2,0x95,0x44,0x60,0x02,0xea,
        0xbb,0xe1,0x12,0x44,0x51,0x6e,0xb5,0xb7,0x1e,0xd8,0x4c,0xb5,0x1a,0x3f,0x45,0x82,
        0xca,0x27,0xe2,0xe9,0x1f,0xce,0x3c,0x2e,0x9b,0xbe,0x87,0x43,0xb5,0x9e,0x97,0x3e,
        0x7f,0x4d,0xa3,0x0b,0x86,0x32,0x4a,0x5e,0xf9,0xcd,0xd3,0xec,0x0e,0x92,0xb9,0xdb,
        0xa2,0xf8,0x67,0x77,0x20,0xcd,0x40,0x26,0xa3,0xcc,0xe2,0x9e,0x5f,0x71,0xac,0x55,
        0x3d,0x0c,0x7e,0x39,0xc5,0x15,0xbf,0xa2,0x41,0xbf,0xa5,0x85,0x1f,0xcf,0xb0,0xea,
        0x98,0xaf,0x78,0xa0,0x8f,0xbe,0xa9,0x2f,0xbc,0xeb,0x4c,0x0e,0x09,0x82,0x48,0x16,
        0x3c,0x45,0x28,0x37,0xd7,0xbf,0x1e,0x6a,0x3c,0xd5,0x48,0xe6,0x15,0x9e,0x33,0x97,
        0xf3,0x75,0x9e,0xcc,0x35,0x4c,0x80,0x30,0x2c,0x43,0x4c,0xfb,0x7d,0x79,0x73,0x69,
        0xc6,0x21,0x2a,0x6c,0x84,0xd9,0x6f,0x9d,0x34,0x38,0x46,0x79,0xb8,0xa6,0x49,0xca,
        0xfd,0x71,0x5f,0x63,0xdb,0x1d,0xcc,0x10,0x3c,0xfb,0x6a,0xcd,0x81,0xfd,0x35,0x36,
        0x21,0xc8,0x0d,0x3f,0x93,0x0b,0xb8,0x25,0x6f,0x0f,0x27,0xa5,0xd0,0x90,0xfa,0x6b,
        0xfc,0xcc,0x46,0xcd,0x47,0xd9,0x95,0xb9,0x34,0x3b,0x2e,0xec,0xde,0xb6,0x97,0x65,
        0x96,0x61,0x59,0x1a,0xce,0xfc,0x03,0xe9,0x36,0x83,0x71,0xd1,0x24,0x03,0x4e,0x62,
        0x39,0xad,0xd8,0x72,0x42,0x29,0xe3,0x12,0x5c,0x2d,0x21,0xc1,0x5c,0x4d,0xa0,0xdf,
        0x6d,0x15,0x94,0x64,0xfb,0x55,0x57,0xd1,0xd0,0xbc,0xae,0x67,0x7d,0xa8,0x4e,0x97,
        0xfc,0x3d,0x9f,0xbb,0x93,0xb5,0xbf,0x03,0xfb,0xf6,0xca,0xb2,0xc2,0x6a,0x59,0x8a,
        0xee,0x0b,0x48,0x84,0xe3,0xbd,0xbd,0xc5,0x87,0xe1,0x65,0xce,0xa3,0x27,0x01,0xf3,
        0x8d,0xa3,0x22,0x0e,0x04,0x24,0x30,0x74,0x5b,0xc1,0xb1,0x28,0xda,0xb4,0xc8,0x4f,
        0x61,0x6c,0xfc,0xe4,0x4e,0xdd,0x3b,0xad,0xa1,0x1b,0x1f,0x6e,0x5e,0x27,0x70,0x5c,
        0x33,0x08,0xe9,0xd4,0x5b,0x1e,0x3f,0x4d,0xc2,0xb4,0x5f,0x8c,0x6a,0xd4,0xf7,0x17,
        0x0d,0x5f,0x39,0xeb,0x04,0x5d,0xdc,0x71,0x67,0x91,0x63,0xaf,0x76,0x50,0xa1,0xbb,
        0x37,0x94,0x7d,0x76,0x61,0x4d,0xf3,0x76,0x79,0xf7,0x5b,0x44,0x3b,0x71,0xee,0xc8,
        0x3b,0x0d,0x86,0x01,0xcc,0xe4,0xa5,0xfa,0x21,0x6c,0xb9,0xf9,0xb2,0x4c,0x9e,0xf9,
        0xe1,0x6e,0x65,0x5a,0xde,0x56,0x54,0xd8,0xc8,0xb3,0x2d,0xba,0x15,0x34,0xb4,0x4b,
        0x33,0x9d,0x6b,0x8e,0x6f,0x1a,0xa0,0x2e,0x17,0xd3,0xa9,0xb4,0xdb,0xc0,0x6f,0xfc,
        0x79,0xbf,0x29,0xea,0x9a,0xe4,0x6a,0x59,0xf6,0x10,0x5e,0x54,0xbf,0xc5,0x50,0x89,
        0x3d,0x38,0x70,0xfa,0xb6,0xa8,0xd4,0xf6,0x90,0xef,0xbc,0x48,0xb9,0x57,0x1a,0xae,
        0x47,0xae,0x52,0x8d,0x5c,0x9d,0x3e,0xe2,0x4d,0x35,0x75,0x7c,0x03,0xcb,0xcd,0x69,
        0xa1,0x06,0x1e,0xae,0x66,0x36,0x49,0x3b,0xd6,0xe7,0x79,0x1d,0x14,0xb7,0xa9,0xf6,
        0x93,0x64,0x67,0xaa,0xed,0x29,0xd7,0x5c,0x13,0x4b,0xfa,0x99,0xa7,0xef,0x30,0xd2,
        0xa6,0x2e,0xfc,0x10,0x4a,0x6b,0x08,0xe3,0x2f,0xe4,0x69,0x9b,0xb4,0x88,0x23,0xbb,
        0xa4,0x09,0xf0,0xab,0x16,0x31,0x3d,0xad,0x91,0x79,0x76,0x12,0x74,0xd8,0x83,0xae,
        0x95,0xd9,0x93,0x89,0x29,0xf0,0x18,0xd7,0xe4,0x0e,0x12,0x2b,0x61,0x73,0x91,0xe7,
        0xc3,0xc4,0x75,0xf7,0x9d,0x5d,0x79,0xbf,0x0f,0xe8,0x70,0x51,0x32,0x2e,0xce,0xe4,
        0xb6,0x2e,0x69,0x82,0xca,0x6c,0x81,0x00,0x3c,0x8c,0xfe,0x33,0xe2,0x1f,0xfa,0x61,
        0x38,0xbd,0x7f,0xf6,0x4a,0x54,0x92,0x78,0xd5,0xbf,0x70,0xbd,0xa9,0x9b,0x17,0x5c,
        0x51,0x56,0x08,0x61,0xf6,0x88,0x4c,0x45,0x81,0x87,0xb5,0x1d,0x00,0x36,0x66,0x11,
        0x4b,0x1d,0x95,0x10,0xe7,0xbf,0x90,0xc2,0x2a,0x27,0xfe,0xbe,0xa0,0xc5,0x68,0xfe,
        0xae,0x78,0xf8,0x8f,0x75,0xec,0x80,0x8d,0xf9,0x26,0xbd,0x4f,0x83,0x5d,0xde,0xdf,
        0x44,0x0c,0x40,0xad,0x3a,0x45,0x7c,0x84,0x58,0x48,0xa3,0xbc,0xe1,0x54,0xc8,0xb2,
        0x15,0xbd,0xbf,0x75,0x0f,0x3f,0x25,0xc2,0xee,0x92,0xa0,0x33,0x33,0x3e,0x68,0xb3,
        0x6a,0xb1,0x07,0x35,0x0d,0x8f,0x5d,0xa6,0xa5,0x49,0xe6,0x1f,0x32,0xf1,0x40,0x60,
        0xcd,0x4d,0xe7,0x7a,0x8c,0x2a,0x44,0xcb,0xa6,0xf2,0xe6,0x2f,0xd7,0x81,0x0f,0x75,
        0x06,0x35,0x72,0x10,0x26,0x44,0x3b,0x0f,0x5a,0x53,0x50,0x50,0x5c,0x44,0xd6,0xf0,
        0x1f,0x4f,0xf8,0x05,0xb3,0x54,0xe3,0x90,0x6a,0x6f,0x15,0xad,0x39,0xce,0xd8,0x0d,
        0x60,0xbf,0x09,0xa6,0x4d,0x0d,0x1e,0xa9,0xbe,0x8d,0x68,0xb5,0x27,0xf4,0x94,0x4a,
        0x53,0xeb,0x78,0x80,0x4d,0x66,0x0d,0xf9,0x81,0x31,0xb7,0x14,0x1f,0xcb,0xcd,0x63,
        0xc0,0x78,0x55,0x60,0x4c,0x92,0x0f,0x5b,0x1b,0x20,0xb6,0xb7,0x5a,0xaa,0x82,0x56,
        0xb1,0x4b,0xf1,0x52,0x22,0x07,0xc7,0xee,0x35,0x5f,0x53,0xcc,0x52,0x23,0xf5,0x60,
        0x6e,0x88,0xdd,0xa4,0xea,0x7a,0x15,0x0d,0xb7,0x33,0xc2,0xbe,0xbf,0x0d,0xa7,0xfd,
        0x80,0x94,0xea,0xe3,0xfa,0xe0,0x1b,0x57,0xcc,0x22,0x72,0x3d,0x9a,0x7c,0x58,0xea,
        0xb1,0x16,0x29,0xdb,0xee,0x6e,0x39,0xa7,0xdc,0xef,0x15,0x33,0x1c,0xc6,0x0b,0x25,
        0x0a,0xf1,0xec,0x9b,0x9d,0x98,0x10,0x1c,0x8f,0xa1,0x9b,0xcf,0xbe,0x7f,0xff,0xea,
        0xd3,0x4a,0xc2,0x6e,0x21,0x15,0x82,0x12,0xd0,0x7c,0x36,0x7c,0x3a,0x7c,0xb6,0xb7,
        0x95,0x88,0x7e,0xe2,0xd3,0xd8,0xae,0x25,0xc6,0x05,0x56,0xea,0x88,0xd3,0xf1,0x49,
        0x1a,0x4d,0x2f,0xc3,0x4b,0x18,0xf8,0x34,0xdb,0x01,0xad,0x03,0xe1,0xd8,0xb1,0x9c,
        0x6a,0x81,0x28,0x20,0x63,0x48,0xfe,0x5a,0xb9,0x75,0x2b,0xf6,0xbe,0x20,0x36,0xed,
        0xcf,0x47,0xf8,0x44,0x34,0x1e,0xa3,0xf6,0x47,0xa6,0x03,0x2f,0xd8,0x81,0x03,0xba,
        0xd1,0x05,0x72,0xbd,0x16,0x8f,0x07,0xa4,0xaf,0x1a,0xa3,0x5b,0x29,0x10,0xd7,0xc0,
        0x39,0x5f,0xa6,0x58,0xa3,0xd0,0x8c,0x40,0x5a,0x95,0xbf,0x67,0xe9,0x20,0xb4,0xfb,
        0x11,0x3c,0xe5,0x21,0xb4,0x56,0xd2,0xe9,0xf2,0x1b,0x45,0x81,0x91,0x49,0xdb,0xa9,
        0xa2,0xbe,0xc0,0x66,0x61,0xd6,0xba,0xfb,0x5e,0xf3,0x69,0x15,0xda,0x5d,0xcd,0x46,
        0x74,0x4d,0x08,0xb4,0x05,0x44,0x65,0x13,0xc8,0xa1,0x9a,0xd0,0xbe,0x73,0x4a,0x8f,
        0x50,0x8c,0xce,0xd8,0x37,0xd7,0x35,0x0d,0x99,0xeb,0x89,0xa0,0x74,0xdf,0x54,0x82,
        0x40,0x60,0x63,0xdf,0xd0,0x02,0xca,0x08,0x7a,0xd4,0x29,0xb1,0x77,0x37,0x2d,0x5c,
        0x8c,0xf0,0x59,0x15,0xea,0x7b,0x06,0x60,0x54,0xa2,0xa8,0x70,0x7f,0x4f,0x54,0x99,
        0xbe,0x9f,0x7f,0x08,0xdf,0x37,0x09,0xb2,0x4f,0xdb,0x7a,0x8a,0x85,0x3d,0x8b,0xf7,
        0x9e,0x12,0xe8,0x85,0x45,0x6b,0x34,0xdb,0xd6,0x43,0x4d,0xed,0xc3,0x54,0xd2,0x72,
        0x36,0x30,0xe3,0x99,0xf8,0x8c,0x28,0xf7,0x91,0xdf,0x15,0xc4,0xb1,0x2c,0x6c,0x48,
        0xce,0x1b,0x03,0x90,0x0f,0x4f,0xc7,0x65,0x69,0xf4,0x01,0x7f,0x08,0x97,0xd8,0xf5,
        0xf0,0x3b,0x17,0xf8,0xe4,0xa9,0x31,0xc1,0x86,0x07,0x83,0xc8,0xc1,0xac,0xd8,0x37,
        0x64,0x33,0x32,0x9e,0x0f,0xce,0xc8,0xe8,0x53,0xdd,0x4b,0x8e,0x15,0xc0,0x6d,0x0a},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x79,0xe4,0x75,0xc9,0x1c,0xb5,0x58,0x50,0xa7,0x99,0xfa,0x88,0x6f,0xa5,0x41,0x97,
        0x1b,0xe7,0x10,0x97,0x49,0x40,0x47,0xf4,0x8a,0x52,0xcd,0x20,0xe8,0x09,0xeb,0xbc,
        0x8b,0xf8,0x96,0x27,0x1c,0x68,0x33,0x17,0xc2,0x65,0x20,0xca,0x0a,0x8e,0x8e,0x5b,
        0x28,0x3c,0x78,0xe0,0xb9,0x07,0x3b,0x3f,0xe3,0xce,0xfd,0xde,0xaa,0x3b,0x51,0x6b,
        0x9b,0x57,0xfd,0xb4,0xff,0xaa,0x67,0x80,0x49,0xa3,0xf3,0xb6,0x41,0x00,0xc9,0x60,
        0x48,0xdd,0x59,0xc6,0x1b,0x88,0xeb,0xd2,0x01,0x1d,0xf3,0x4d,0x2e,0x36,0xb5,0xd1,
        0x26,0x08,0xf9,0xb0,0x28,0x80,0x81,0xd8,0x51,0xd2,0xe6,0xc0,0xf6,0x15,0xe8,0x5d,
        0xe3,0x91,0xe4,0xd5,0xfa,0xf4,0x51,0x1b,0x7d,0xa2,0x1b,0x09,0xe4,0x74,0x88,0x01,
        0xf2,0xdf,0x68,0x9a,0xfa,0xdd,0x90,0x4b,0xfa,0xd5,0x67,0xd4,0xa5,0xaf,0xb1,0x91,
        0x15,0x45,0x36,0xfb,0xf6,0x24,0x57,0xa8,0x92,0x9f,0xea,0x5c,0x45,0xb9,0x9c,0x53,
        0xe1,0x1c,0x80,0x15,0xed,0x84,0x3b,0xb5,0x5a,0x58,0xfc,0x76,0xde,0xff,0x8a,0x03,
        0x45,0x76,0x2a,0x71,0xee,0x91,0x3e,0x17,0xd5,0xc0,0x62,0xde,0x5b,0xec,0x16,0x3e,
        0x10,0xd2,0x82,0x0a,0x4c,0xa3,0x09,0xcf,0x91,0x1e,0x12,0x2b,0x95,0x90,0xb8,0x1b,
        0x6b,0x83,0xa8,0xa4,0xf3,0xb3,0x50,0x36,0x8e,0xe9,0x5b,0xfe,0x29,0xe2,0xb3,0x32,
        0x73,0x9b,0x02,0x53,0x3e,0x19,0xda,0x29,0x64,0x3b,0x70,0x12,0x34,0x89,0x49,0x17,
        0x30,0x67,0xf0,0x14,0xa5,0x9a,0x56,0x65,0x8e,0xda,0xfe,0x82,0x6c,0xb3,0x64,0x17,
        0xa1,0x48,0x17,0x88,0x58,0x94,0xfe,0xdd,0x2b,0xa2,0x90,0xcd,0x61,0xf8,0xc1,0x45,
        0xcd,0xae,0x76,0x13,0xbe,0x7d,0x19,0x03,0x80,0x5a,0x62,0x32,0xb6,0x43,0x85,0xb2,
        0xb6,0xa1,0xad,0xfc,0x97,0x18,0x99,0x06,0x68,0x8b,0x32,0x1e,0xb0,0xca,0x61,0xa7,
        0xd1,0xb5,0x78,0x1d,0xf3,0x4a,0x2d,0xde,0xc5,0xf8,0xdc,0xc8,0x29,0x84,0xcd,0x08,
        0x61,0xbb,0xf7,0xea,0x4a,0x05,0x19,0xad,0x68,0x47,0x5d,0x78,0xbb,0x80,0xa9,0x53,
        0xad,0xf2,0xeb,0x7c,0x65,0xdb,0x98,0x31,0x12,0x87,0x92,0xb0,0x3f,0x33,0x79,0xfb,
        0xce,0x82,0x64,0xb7,0x41,0xc6,0x1b,0x9c,0x4e,0x98,0x9e,0xc6,0x67,0x63,0xcb,0x69,
        0xc4,0x36,0xa5,0x9a,0x2b,0x29,0x3a,0x6d,0xc5,0x3b,0xf8,0xce,0x8f,0xa6,0x44,0x76,
        0x01,0x36,0xfc,0x30,0x9d,0x1f,0x01,0x95,0x6d,0x43,0xf2,0x21,0xd8,0x69,0x7e,0xa2,
        0xa0,0x22,0x5c,0x12,0x2d,0x30,0x02,0xe8,0xc7,0x9d,0x4d,0x8c,0x76,0xa8,0xa5,0x25,
        0xe5,0x8b,0x00,0x6b,0x12,0x55,0xa8,0x17,0x52,0xfd,0xb4,0x88,0x06,0xb9,0x06,0x49,
        0x95,0xe0,0x93,0x9e,0xa2,0xb2,0xe7,0x67,0xc6,0x7a,0x69,0x40,0xa5,0x36,0xa0,0x86,
        0x1b,0xad,0x56,0xd4,0xf1,0x1d,0xfd,0x8e,0x97,0x09,0xa6,0xec,0x14,0x47,0xad,0x94,
        0x6e,0xd5,0x39,0x65,0x0b,0x88,0xd8,0x79,0x26,0xda,0x90,0x01,0x33,0xea,0xb2,0xb4,
        0x80,0x06,0xc9,0xc5,0x27,0x57,0x3b,0xb4,0xd6,0x29,0xb1,0xb7,0x2d,0xa0,0x54,0xa2,
        0x9e,0xab,0x33,0xe4,0x4e,0x4d,0x17,0xb6,0x94,0x04,0x40,0x86,0xe0,0x14,0xcc,0xd8,
        0x13,0xf8,0x5e,0x27,0x93,0xa4,0xb3,0xa2,0x0b,0x8d,0xbc,0xd7,0xc6,0x75,0x4c,0x52,
        0x76,0x2c,0x97,0xfa,0xf3,0x1f,0xf1,0x3e,0xd0,0x45,0xfe,0x64,0x7d,0xcb,0x55,0xe9,
        0x6a,0xee,0x26,0x01,0xa2,0xaf,0x23,0xf1,0x26,0x02,0x11,0x55,0xd4,0xf5,0xda,0x00,
        0x2e,0x7e,0xd4,0x8e,0x13,0xa6,0x01,0x61,0x55,0x0d,0x80,0xf6,0x7b,0xd2,0x61,0x79,
        0x08,0x86,0x66,0xcf,0x79,0xbd,0x59,0x17,0xf1,0xf7,0xfd,0x54,0x25,0x29,0xcd,0x47,
        0x53,0x5d,0xb7,0x3a,0xc1,0xf7,0xf1,0x3a,0x27,0x33,0x4c,0xc3,0x1b,0x4d,0xc9,0xf3,
        0xcc,0x21,0x7d,0x07,0x38,0xdd,0x81,0xe9,0x43,0xe4,0x6d,0x2d,0xcc,0x4a,0x43,0x2f,
        0x94,0xb7,0x17,0x81,0xed,0x4d,0x68,0x4b,0x64,0x72,0xd3,0xc9,0x2f,0x5a,0xe6,0x4a,
        0xdb,0xe2,0xe5,0xd9,0xfe,0xb5,0xcc,0x2d,0x98,0x28,0xcc,0x9e,0xd9,0x26,0x2b,0x4f,
        0xae,0x75,0xa7,0x94,0x27,0x48,0xf3,0x4c,0x60,0xab,0x43,0x27,0x11,0x91,0xf2,0x52,
        0x71,0xe6,0xce,0x42,0x4e,0x2f,0x3a,0x87,0x9c,0xc0,0x8b,0xcb,0xdf,0xd2,0xb9,0x68,
        0x76,0x2d,0x6a,0xf9,0x22,0x7c,0xdb,0x0e,0xf1,0x1c,0xec,0xd0,0xda,0x88,0xac,0xed,
        0x46,0x7b,0x03,0x54,0x16,0xe1,0x75,0xf7,0xa9,0x39,0xed,0xef,0xb6,0x8c,0xeb,0x69,
        0xe9,0xc7,0x6c,0x43,0x1c,0xc1,0x97,0x45,0xc0,0xbf,0x89,0xde,0x7f,0x5d,0xd4,0x80,
        0xdc,0xcc,0x01,0x6c,0xe0,0x84,0xe2,0x2c,0xef,0xa3,0xbf,0xab,0x56,0x69,0x8a,0xba,
        0x4d,0xf1,0x86,0x13,0xe1,0x92,0x09,0x31,0xe8,0x78,0x59,0x85,0x47,0xfd,0xe2,0x0f,
        0x1a,0x15,0x51,0x6a,0x97,0xb3,0x43,0x70,0x38,0xcc,0x88,0xb4,0xa7,0xf3,0x21,0x8e,
        0xbc,0x72,0x86,0xa8,0x4f,0x54,0x9f,0x24,0xb7,0x0a,0x45,0xee,0x37,0x9a,0x72,0xc7,
        0x86,0x73,0x35,0x38,0x50,0xc4,0xca,0xa1,0xb9,0x6c,0x76,0xf8,0xea,0xd4,0xcd,0x55,
        0xc9,0x1d,0x4f,0x40,0xd7,0x1b,0xd9,0x28,0xec,0x71,0x78,0x70,0xde,0x79,0x6b,0x62,
        0xdb,0x8b,0x7f,0x81,0xf0,0x85,0xf6,0xa1,0x56,0x7b,0x56,0xe7,0x42,0x98,0x30,0xb6,
        0x3b,0x6a,0x9b,0x43,0xa5,0x67,0x3c,0x3f,0x01,0x84,0x5d,0x66,0xca,0xcd,0x9a,0xc6,
        0xd9,0x09,0xc2,0x84,0x49,0xb0,0x74,0x5f,0xd0,0xef,0xed,0x5c,0x52,0xc4,0xc4,0xd1,
        0xac,0x9f,0x1b,0xe1,0x68,0x18,0x76,0x13,0x1a,0xa5,0xc5,0xc0,0xc3,0x1d,0x3a,0x3c,
        0xb2,0xf4,0x82,0x8e,0xb6,0x99,0xc7,0x2a,0xab,0x4a,0x4c,0x1a,0x4b,0xdd,0x28,0xed,
        0x44,0x10,0x06,0xfb,0x0e,0xe2,0x1c,0x61,0xca,0xc8,0x88,0x30,0x9a,0x31,0x23,0x6f,
        0x71,0xe4,0xd0,0x4e,0x15,0xa1,0x2a,0xfd,0xfc,0x18,0x5a,0x84,0x62,0xf8,0xbf,0x16,
        0x01,0x26,0x06,0x38,0x51,0x4b,0xc1,0xb6,0x90,0xd2,0x13,0xc2,0x8f,0xb9,0xd0,0x69,
        0x71,0xf7,0xc9,0x9b,0xd7,0x46,0x8a,0xca,0x09,0xac,0xdc,0xc7,0x51,0x0f,0x36,0x2e,
        0xb5,0xf5,0x55,0xf1,0x69,0x18,0x7a,0x12,0xd8,0x3b,0x34,0x31,0xac,0x1c,0x18,0xfd,
        0xc5,0x23,0x4f,0x8c,0x98,0x39,0xa8,0xdf,0xab,0x52,0xee,0x3a,0x64,0xfc,0x44,0xbc,
        0x24,0xc5,0x4d,0x1f,0x1e,0x4c,0x3b,0xae,0xf5,0x64,0x33,0xf4,0xbd,0xa7,0x0b,0xc2,
        0xb8,0xe3,0xe4,0xaa,0x22,0xfc,0x91,0x67,0xdf,0xdf,0xfe,0x0e,0x34,0xa7,0xce,0x4a,
        0xd5,0xc8,0x33,0x61,0xdd,0x40,0x8f,0x3e,0xf9,0x93,0x66,0xb7,0x0d,0xdb,0x43,0x29,
        0x8f,0x61,0x91,0xe5,0xe3,0x80,0x6b,0xa0,0x07,0x4e,0x84,0xc1,0xf9,0x36,0x1e,0x1f,
        0x3a,0x91,0xa7,0xc4,0xa3,0x27,0x50,0xaf,0xb8,0xde,0x97,0x31,0xf5,0x7a,0x37,0xc8,
        0xa5,0x17,0x2f,0xe2,0xdf,0x3d,0x35,0x4a,0x3f,0xc0,0xbb,0xa3,0x81,0x29,0x74,0x95,
        0x0b,0x18,0x2d,0x70,0x66,0x8b,0x96,0x40,0xd1,0x90,0xb9,0xa1,0x29,0x6d,0xef,0xa9,
        0x80,0xda,0x9e,0x77,0xbe,0xb8,0xb2,0x2a,0x26,0x1d,0x04,0x02,0x57,0x5d,0x36,0x8e,
        0xe5,0x83,0xb3,0xdc,0xcb,0xdc,0x8c,0xda,0x5e,0x17,0x3a,0x0d,0x94,0x5e,0x9e,0x83,
        0xaf,0xf2,0x52,0x8d,0xdd,0x0d,0x62,0x66,0x13,0xa0,0x67,0xb6,0x96,0x5e,0xc5,0xc5,
        0x6f,0x4c,0xc8,0xda,0x0e,0xb6,0x22,0x04,0xdf,0xe2,0xd2,0x1e,0xa3,0xdd,0xf1,0x33,
        0xfa,0x9d,0x80,0x8f,0xeb,0xee,0x1d,0xd3,0x2a,0x26,0x33,0x2e,0x21,0xcb,0xf1,0x37,
        0x05,0x11,0xd4,0x84,0xac,0x4a,0xf3,0x40,0x27,0x8b,0x4d,0xc8,0xb6,0x66,0x31,0x50,
        0x65,0x89,0xf2,0xb6,0x2d,0x02,0x36,0xa6,0x36,0xd1,0x50,0x99,0x2a,0x7c,0x38,0xd4,
        0x58,0x84,0x8a,0x1a,0xa1,0x67,0x6c,0x2a,0xe2,0x45,0xdf,0x9d,0xb8,0x5b,0xf3,0x75,
        0x08,0x5a,0x64,0x93,0x74,0xb6,0xd9,0xe7,0x19,0xe6,0x75,0x56,0x0e,0x16,0x7c,0x93,
        0x30,0xa8,0xb4,0x97,0x64,0x7c,0x3d,0xe8,0x8f,0x9c,0xc1,0xcc,0xf8,0xe7,0x49,0x16,
        0xae,0x8f,0x81,0x70,0x4c,0x62,0x7c,0x35,0x67,0x09,0x4f,0x1e,0x16,0x4e,0x6e,0x14,
        0x8f,0xb4,0x8f,0x1a,0xb5,0x07,0x8d,0xa0,0x7f,0x29,0x47,0xc6,0x2b,0x8b,0x45,0x58,
        0x4f,0x05,0x34,0xd7,0x32,0xc6,0x38,0x05,0x22,0x88,0xe1,0x7d,0x2d,0x6d,0xa6,0x16,
        0x18,0x68,0xe1,0x2c,0x68,0x11,0x5c,0xc9,0x3c,0xd2,0x6e,0xc3,0xf8,0x59,0xba,0x5d,
        0x65,0x69,0xfd,0xee,0xf5,0xc4,0x54,0x6a,0x42,0xd2,0xae,0x06,0x34,0x7a,0x89,0x6a,
        0xa1,0x77,0xd2,0x4a,0xbb,0xd9,0x93,0x88,0x95,0x46,0x30,0xec,0x67,0x0f,0xda,0x82,
        0x52,0xb0,0x09,0x69,0xc4,0xc2,0x90,0x59,0xcc,0xac,0xb5,0xe2,0x91,0xce,0x9a,0x58,
        0xdc,0xb4,0x1c,0xd0,0x01,0xd0,0xbe,0x0c,0x7a,0xa4,0x0f,0x26,0xa3,0xd2,0xac,0x67,
        0x19,0xcc,0xbc,0xfc,0x3a,0xa4,0x98,0x5f,0xef,0x0e,0x8e,0x52,0x72,0xf9,0x89,0xea,
        0xe2,0x5d,0x16,0x71,0xf3,0xb5,0x53,0xae,0x37,0x76,0x35,0x3d,0xcf,0x77,0x3c,0x03,
        0x5d,0x96,0x04,0xea,0x25,0x51,0x7e,0x33,0x56,0x4e,0x86,0xcf,0x44,0x50,0x9b,0x7c,
        0x0e,0xe7,0x16,0x57,0xe8,0x5e,0x7a,0xcf,0x49,0x99,0x7b,0x38,0x81,0x0d,0x62,0x0e,
        0xed,0xc9,0x2b,0x79,0x74,0xfe,0xbe,0xcc,0xf1,0xe4,0x40,0xe2,0x96,0x4f,0x84,0xe9,
        0x5a,0x00,0x33,0x01,0x9a,0x38,0x9c,0x96,0x0c,0x39,0xfa,0x1f,0x89,0x88,0xb0,0x32,
        0x43,0x94,0xa7,0x87,0x7d,0x48,0x24,0xab,0x62,0x75,0x79,0x33,0x67,0x76,0x05,0x53,
        0x35,0xbd,0x1f,0xbe,0xa1,0x85,0x35,0x5f,0x50,0xd3,0x4d,0xfc,0xfb,0x20,0x08,0x10}, 
        /*TST_dataSize*/
        1536*sizeof(DxUint8_t),       
        CRYS_AES_ECB_mode
	}
};



TST_Ext_AES_MAC_TestDataStruct SEP_AES_MAC_Acceptance_TestData[] =
{

	{
	
        /************/
        /*        AES CBC MAC vectors     */
        /************/

        {"Acceptance test - AES/MAC/256Key/1356ByteData "},
        /*TST_Key*/     
        {0x60,0x3d,0xeb,0x10,0x15,0xca,0x71,0xbe,0x2b,0x73,0xae,0xf0,0x85,0x7d,0x77,0x81,
         0x1f,0x35,0x2c,0x07,0x3b,0x61,0x08,0xd7,0x2d,0x98,0x10,0xa3,0x09,0x14,0xdf,0xf4},
        CRYS_AES_Key256BitSize,
        /*TST_IvCounter*/
        {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}, 
        /*TST_input_data*/
        {0xDD,0x2C,0x3D,0x7C,0x9C,0xD9,0xBA,0x82,0x98,0x18,0xE1,0xA2,0x13,0xA3,0x7E,0xCB,
        0x4C,0x80,0x75,0x97,0x70,0x41,0x56,0x6C,0x2C,0x52,0x56,0x56,0xC8,0xE7,0x51,0x90,
        0x2D,0xA2,0x2E,0x62,0xF9,0x71,0xDB,0xEB,0xCA,0xCD,0x89,0x8F,0x8C,0x19,0x66,0x63,
        0x15,0xE7,0x91,0xE3,0x47,0x25,0xD7,0x9C,0xD5,0xD1,0x50,0x4A,0x82,0x64,0xBA,0xB0,
        0xC7,0x50,0x75,0x71,0x74,0x1B,0xD2,0xDA,0xA4,0x8A,0xCD,0xA2,0xB8,0xC7,0xE0,0x12,
        0xEB,0xF3,0x40,0xE0,0x56,0x6E,0x49,0x08,0xCA,0x92,0x8D,0x28,0x20,0x91,0x69,0x66,
        0x13,0xD8,0xC8,0x3B,0xA4,0xF5,0xEE,0xF9,0x15,0xB6,0x3E,0xBD,0x57,0x34,0xE4,0x0D,
        0xF1,0x3D,0x5E,0x8F,0x23,0xD9,0x5A,0x58,0x06,0x6D,0xA7,0xE2,0x8D,0xAA,0xBA,0x13,
        0x20,0x67,0x8F,0xDF,0xFE,0xA4,0x6E,0xF5,0x04,0x47,0xCA,0xA0,0x30,0x8C,0xB0,0x95,
        0xAD,0x7F,0x36,0xE3,0x32,0xDA,0x43,0x3A,0x7D,0x6F,0x34,0x36,0x4E,0x0B,0x6C,0x6B,
        0xFC,0x2A,0x9C,0xF0,0xA5,0x04,0x0E,0x4D,0xCE,0x68,0x8A,0xDC,0x0E,0xBA,0x28,0x7A,
        0xBD,0x11,0x34,0x0D,0x73,0xD6,0xE1,0x46,0x24,0x55,0x62,0x8F,0x6F,0x38,0xA7,0xF9,
        0xDA,0x5F,0xA3,0x05,0xF0,0xC0,0xEF,0xA9,0x70,0xE9,0x14,0xC9,0x50,0x66,0x2B,0xC3,
        0x46,0xBA,0x79,0x3C,0xD7,0x5E,0xF8,0x25,0x49,0x55,0xCB,0x50,0xA2,0x7F,0xDD,0x96,
        0xC1,0x90,0x01,0xAF,0x16,0x23,0x8A,0xFC,0x22,0x8B,0x9C,0x89,0xC1,0x17,0xF6,0xBD,
        0x2A,0x9E,0x48,0xB5,0xBE,0x6A,0x22,0x7C,0x66,0x7D,0xBC,0x9A,0xF4,0x9E,0x07,0xF1,
        0x0C,0x7E,0x08,0xBF,0x65,0x7B,0xAC,0x23,0x2F,0x7C,0x1A,0x4B,0xC1,0x6E,0x63,0x32,
        0x5F,0x0E,0x26,0x03,0x37,0x28,0xD7,0x56,0x6E,0x85,0x49,0x98,0x66,0xF0,0x08,0x83,
        0x84,0xAB,0x7D,0x43,0x0E,0x37,0x57,0xAE,0xF2,0x24,0x85,0x42,0x50,0xD6,0xBA,0xF7,
        0x19,0x8A,0x3A,0xE5,0x78,0x03,0xBA,0xE4,0xA6,0xB2,0x50,0xE0,0x32,0x13,0xBD,0x3F,
        0x73,0x97,0xC7,0x16,0xF1,0x20,0x23,0x27,0xB6,0x77,0x11,0x12,0xA2,0x95,0x06,0x98,
        0xCB,0x51,0x7F,0xDC,0xB5,0x23,0x0A,0x80,0xF1,0x99,0x9D,0x5C,0xE7,0x77,0x7C,0xDE,
        0x67,0x46,0xCE,0xB9,0x0E,0xA3,0x06,0xF9,0x66,0x13,0x2E,0x00,0xF2,0xA7,0x41,0x10,
        0xAC,0xB7,0x14,0xE0,0x94,0xE0,0x8A,0x50,0x8C,0x47,0x25,0x58,0x82,0xC6,0x40,0x3F,
        0xFA,0x32,0xAB,0x5C,0xC7,0x4C,0x8A,0x27,0x4A,0x85,0x75,0xA2,0xF4,0x09,0x8D,0x49,
        0x57,0x8D,0xB0,0x30,0x62,0x9B,0x4A,0x86,0xBB,0x7D,0x2C,0xC7,0x7E,0xAE,0x76,0xA0,
        0xD2,0xEF,0x06,0xC0,0xFB,0xE5,0x48,0x5F,0x2D,0xED,0x96,0x0E,0x6A,0xE7,0x5B,0x82,
        0xB9,0xDB,0x01,0xF5,0x16,0x10,0xDC,0x5E,0xE7,0x25,0xA0,0x49,0x20,0xC3,0xA9,0x9C,
        0x0E,0xD5,0xCF,0x05,0x03,0xCD,0x4E,0x71,0x44,0x51,0x03,0x75,0x05,0x3B,0x1C,0xD4,
        0x21,0xA9,0x0D,0xA2,0xAC,0x81,0x89,0xC2,0x13,0xA7,0xD8,0xD6,0x45,0xFF,0x3E,0x69,
        0x44,0xF9,0x00,0x94,0x18,0x56,0x7E,0xEB,0x8C,0x8F,0xB1,0xC4,0x0D,0x66,0x59,0xAC,
        0x09,0xCC,0x27,0x76,0xB5,0x06,0xEF,0x8D,0x4B,0x0C,0xF2,0x5C,0xF5,0x78,0x2C,0x45,
        0x12,0x99,0x31,0x0C,0x3B,0x87,0xBB,0xCA,0x2B,0x22,0x16,0x1D,0xD0,0xC5,0xB5,0xAC,
        0x4D,0x2C,0xCD,0x78,0xD7,0xC8,0xB4,0x3D,0x09,0x73,0x48,0x0B,0x64,0x22,0xF6,0x14,
        0x62,0x6B,0xB2,0x74,0x35,0x4D,0x70,0x81,0x10,0x5D,0x4B,0x93,0xF0,0xD2,0xBC,0x86,
        0x57,0x45,0x0E,0xC8,0xAA,0xB3,0x6E,0x49,0xE4,0xF3,0x02,0xC8,0x3E,0xAF,0x66,0x08,
        0x2B,0x01,0xBA,0x64,0x13,0x41,0x76,0x00,0xBB,0x4B,0x68,0x7A,0x7D,0x21,0x4D,0x37,
        0xB6,0xC1,0xB3,0x1E,0x13,0x2E,0x69,0xAF,0xFD,0x68,0x8F,0x41,0x4B,0xA8,0x42,0x60,
        0xF6,0x42,0x67,0xEE,0x17,0x58,0x73,0x16,0xCF,0x0E,0x0C,0x5F,0x4B,0xF4,0xCC,0xC2,
        0xA5,0xCA,0x12,0x7C,0xFC,0x47,0xF5,0xFD,0x97,0x0B,0x66,0xAA,0xB1,0x34,0xB5,0x13,
        0x08,0x07,0x83,0x3B,0xB9,0x5E,0x20,0x5D,0x4E,0x9D,0x4F,0x05,0x21,0x0A,0x63,0x09,
        0x9C,0xCC,0x9C,0x80,0x96,0xC6,0x64,0xAF,0x4C,0x69,0x57,0x0B,0xF1,0xC9,0x64,0x9A,
        0x58,0xF8,0x56,0x43,0x70,0x90,0x08,0x46,0xAA,0xB4,0x2E,0x5E,0xF7,0xF0,0xDC,0x8C,
        0xA7,0x5D,0x0E,0xE4,0x98,0x34,0x7D,0x42,0xA2,0xD3,0xEE,0x50,0x07,0x14,0x6C,0x85,
        0x38,0xB4,0xAC,0x28,0xB4,0x1F,0x98,0x0B,0xC3,0x55,0xD6,0xE1,0x97,0x06,0xB7,0x5C,
        0x8D,0xCA,0x63,0x94,0xBA,0x7F,0x02,0x23,0x7B,0x13,0xA1,0x9D,0xA2,0xB8,0x3F,0x95,
        0x47,0xA9,0x26,0x43,0x44,0xB3,0xD7,0x88,0xC4,0x02,0x21,0x43,0x5E,0x9B,0xAB,0x9C,
        0x1B,0x92,0xC2,0x3D,0xB1,0xD8,0xCA,0xB8,0xB1,0x88,0xAD,0xA1,0x7E,0xFB,0x69,0x0A,
        0x16,0x40,0x99,0xEE,0xE0,0x74,0x17,0xDA,0xF2,0xDB,0xCF,0xB7,0x5E,0xBF,0xC5,0xDF,
        0x68,0x04,0x81,0x0F,0xF6,0x02,0xE4,0x6F,0xDF,0x6D,0x91,0xBC,0x06,0x36,0x09,0xC9,
        0x99,0x16,0x2D,0x1D,0x01,0xBC,0xBC,0xA6,0x7A,0xE7,0x4A,0xD5,0x08,0x12,0x59,0xF2,
        0xC2,0xCD,0x38,0x79,0x79,0x59,0x13,0x13,0x5C,0x2A,0x0E,0x72,0xE3,0x5B,0xD3,0xBC,
        0xD1,0x05,0x1E,0x48,0x92,0xA7,0xDD,0xAB,0x48,0xDB,0x95,0x0E,0xB8,0x0E,0x66,0xCC,
        0x13,0x9E,0xF9,0x39,0xFE,0x8F,0x50,0x40,0x02,0x19,0xC0,0xD7,0xAD,0x49,0xC3,0x1E,
        0x14,0x8D,0x04,0x03,0xF4,0x11,0x60,0x1A,0xEF,0x8C,0x31,0x9E,0xC4,0x05,0x5B,0x4E,
        0xC3,0x42,0x5E,0x44,0x62,0x9A,0xBE,0x41,0xB5,0xDD,0x45,0x79,0xE7,0x05,0xFD,0xFE,
        0x17,0x76,0xFA,0x2A,0x0A,0x63,0xD8,0x01,0x3E,0xDE,0x49,0x71,0x5E,0xB2,0x7B,0xFD,
        0xBD,0x72,0x14,0x6B,0xEB,0x7F,0xBC,0x7A,0xCF,0xC2,0x4D,0x16,0xCC,0xE6,0x33,0xE9,
        0x8F,0x32,0x86,0x4E,0x0A,0x31,0x44,0x5F,0x69,0x5C,0x05,0x83,0x50,0x4D,0xE3,0x02,
        0x62,0x47,0xBC,0x74,0xF0,0x92,0x13,0x97,0xB9,0x80,0x5A,0x48,0x15,0xC1,0x35,0x58,
        0xAA,0x5F,0xE1,0x2C,0x2B,0x2D,0xF2,0x8B,0x2E,0xB5,0x01,0x8E,0x7A,0x39,0x29,0x82,
        0xDF,0x4B,0xB4,0x84,0x2A,0xBE,0xF8,0xFD,0x1F,0xEF,0x94,0x8A,0xD7,0xFB,0x49,0xA8,
        0x27,0xAD,0xD8,0xF0,0x6B,0xB7,0xD6,0x34,0x54,0x30,0x46,0x3B,0x90,0x85,0x1D,0x80,
        0x57,0xD8,0x68,0xCA,0x0D,0xB0,0x2D,0xEB,0x66,0xE4,0x0C,0x3C,0x98,0x68,0xB4,0x32,
        0x6C,0x59,0x66,0xCD,0x60,0x38,0x17,0x28,0x74,0x7F,0x30,0xF9,0x78,0xBD,0x6C,0x99,
        0xD1,0x14,0x33,0xFF,0x93,0x7E,0x9B,0x76,0x7F,0xEC,0x8A,0x86,0xAA,0x9A,0x9C,0xEB,
        0x7C,0x14,0xCE,0x37,0x1E,0x50,0x1F,0x1E,0xC0,0x40,0x55,0x8D,0x80,0x33,0x73,0xA8,
        0x78,0x73,0x6A,0x83,0x35,0xB5,0x9F,0xED,0xBE,0xF0,0x4D,0x74,0xAE,0x91,0x7E,0xDA,
        0xE3,0x44,0x7D,0x64,0xEF,0x35,0x7B,0x81,0xF5,0x14,0x3E,0x52,0x28,0x0E,0xF5,0x4C,
        0x79,0xE1,0x0D,0x36,0x2F,0x18,0xB6,0xC7,0x74,0xE0,0x79,0x2E,0x02,0xAB,0x70,0x2F,
        0xC2,0x7B,0xA9,0x3C,0xB6,0x0E,0xB9,0x42,0xF7,0xE9,0x8E,0x21,0x76,0x4D,0xC4,0xAF,
        0xFA,0x01,0xFA,0xCC,0x83,0x47,0xAB,0xCA,0x8D,0xB5,0xEF,0x0E,0xBC,0x4D,0x7E,0x49,
        0xA3,0x0E,0x8F,0xAD,0x64,0xB9,0x95,0x6A,0x27,0xCB,0x3F,0x46,0x8A,0x95,0x50,0x27,
        0x1B,0xC9,0x33,0x01,0xB0,0xA3,0xAC,0x7B,0xD0,0xDE,0xAF,0x00,0x1E,0xAA,0x85,0xAA,
        0x6A,0x44,0x7D,0x67,0xBD,0x17,0x4B,0x41,0x6B,0x90,0xA4,0xB7,0x08,0x64,0x40,0xF8,
        0x65,0xC8,0xF2,0xF3,0x19,0x7D,0x99,0xFF,0x62,0x13,0xDD,0x86,0x09,0x95,0x4B,0x7C,
        0x45,0x94,0xDC,0x46,0x17,0xE8,0x69,0x04,0x7D,0xF2,0x95,0x20,0xFF,0xF4,0x73,0x6B,
        0x9E,0xB6,0x9A,0x56,0xB8,0x92,0x91,0xEC,0xAA,0x7D,0x05,0xAA,0x3A,0xC5,0x37,0xD6,
        0x44,0x28,0x72,0x73,0x88,0xFA,0xE0,0x7D,0x5E,0xEE,0x75,0x26,0xE7,0x79,0x00,0x6E,
        0xA0,0x71,0xE7,0x53,0xFA,0xF5,0xC4,0xB2,0x02,0xEF,0x9B,0x9A,0xE3,0xBF,0xCA,0xB8,
        0xBB,0xBF,0xDB,0xD6,0x81,0xFF,0xE3,0xA3,0xD6,0x1D,0xF7,0xC9,0x1D,0x6B,0x04,0x31,
        0x7D,0x97,0x0A,0xC8,0xDD,0xE4,0xDC,0x4F,0x63,0xBF,0x71,0x98,0x5F,0x46,0x9A,0x9F,
        0x24,0xBC,0x6B,0x28,0x9E,0x29,0xEC,0xA0,0x8E,0x44,0x7C,0xDC,0xFE,0xFA,0x95,0x97,
        0xEB,0x69,0x1C,0x4B,0xB5,0x01,0xDB,0xD7,0xE3,0x8B,0x73,0xC2,0x8E,0x4A,0x44,0x8F,
        0x83,0x57,0xA5,0x60,0xFF,0xDC,0x93,0x53,0xAA,0x69,0x3A,0x98,0x67,0xFF,0x51,0x68,
        0x29,0xD9,0xAD,0xF5,0x29,0x4E,0xEA,0x22,0xE1,0x94,0x45,0x12,0xB6,0x29,0x11,0x43,
        0x00,0xEC,0x59,0xA6,0x55,0x35,0x97,0x0E,0xD5,0xC9,0xA1,0x4B,0xC7,0x42,0x6F,0xE3,
        0x3A,0x0B,0x98,0xB4,0x9D,0x4E,0x66,0x35,0x6D,0x83,0x7F,0x6B,0x96,0x81,0x9D,0x80,
        0x57,0xF6,0x98,0x7A,0xA6,0xAB,0x13,0xF4,0x42,0x9E,0x1F,0x60,0xAC,0x9E,0x5A,0x9E,
        0x24,0x61,0xD7,0xAB,0x91,0x5D,0xA6,0xB2,0x86,0x23,0x38,0xD2,0xB5,0x2C,0x78,0x54,
        0x2C,0x20,0xF3,0xD1,0xA9,0xF4,0x3D,0x8F,0xF7,0xA3,0x72,0xFE,0x2E,0x06,0x88,0xCE,
        0x28,0xE0,0x46,0x34,0xAA,0xF2,0xEF,0xFA,0x4F,0xE6,0xF4,0x83,0x72,0x41,0x3F,0x15,
        0x26,0xCB,0x33,0x8C,0xAB,0x89,0xF4,0x2F,0x24,0x47,0xB3,0xED,0xEB,0xA8,0x83,0x80,
        0x9A,0x69,0xA9,0xD4,0xE5,0x43,0xAA,0x3A,0x31,0xF8,0x81,0xC3,0x00,0xBA,0x1C,0xB6,
        0x64,0x5C,0xD8,0x62,0xD2,0xFC,0x23,0x9E,0xEC,0x16,0x10,0x62,0x3E,0x01,0x0F,0xA7,
        0x62,0x73,0xE8,0x08,0x97,0x6A,0x30,0xE2,0x21,0xF9,0x5B,0xB2,0x07,0x31,0x2F,0x6A},
        {0},
        /*TST_dataSize*/
        1536*sizeof(DxUint8_t),
        /*TST_Expected_CBC_MAC*/
        {0x30,0xA4,0xD0,0x86,0xBE,0x3A,0x64,0x22,0x9B,0x8E,0xCD,0xC6,0x04,0x33,0x57,0x04},  
        CRYS_AES_MAC_mode
    }
};


/***************************/
/************** XCBC MAC Vectors    ********/
/***************************/		   
TST_Ext_AES_MAC_TestDataStruct SEP_AES_XCBC_CMAC_Acceptance_TestData[] =
{
    { 
        {"Acceptance test - AES/CMAC/256Key/1536ByteData "},
        /*TST_Key*/     
        {0x3D,0x62,0x62,0xD8,0xB0,0x06,0xFD,0xD5,0x4D,0x6D,0x81,0x8E,0x7B,0x6C,0xFC,0x71
        ,0x6D,0x0C,0x9C,0x93,0x87,0xF2,0xA6,0x70,0x4D,0x6D,0x81,0x8E,0x7B,0x6C,0xFC,0x71},
        CRYS_AES_Key256BitSize,
        /*TST_IvCounter*/
        {0x00}, 
        /*TST_input_data*/
        {0x97,0xFA,0x87,0x45,0x20,0x76,0xEB,0x05,0x12,0xAD,0x04,0x41,0xE0,0xD0,0xAF,0xC1,
        0x91,0x7C,0x96,0xE6,0x66,0x78,0x62,0x57,0x67,0x2F,0xBF,0x42,0x06,0x1D,0xAC,0xB0,
        0x4E,0x43,0xC1,0x95,0xC0,0x7A,0xF8,0xEB,0x77,0x6C,0xFF,0x16,0x7F,0xB9,0x4E,0x6B,
        0xB0,0x55,0x80,0x86,0x9B,0x58,0xF2,0x1E,0x98,0x30,0xDD,0xF0,0xB7,0xA9,0xFF,0xF5,
        0x01,0x54,0xF2,0x9C,0x0F,0x1A,0x00,0x16,0x83,0xAA,0x6F,0xF9,0x79,0x4B,0xD8,0xAD,
        0xE1,0x54,0x92,0xB0,0x9C,0x26,0x14,0xF6,0x50,0xA2,0xFD,0x90,0x9D,0x08,0x34,0xCD,
        0x6D,0x0A,0x15,0x2B,0xC7,0xB2,0x5C,0x95,0x55,0x69,0x03,0xF1,0xE9,0xF9,0xA5,0x4C,
        0x57,0x2F,0x0F,0x62,0x16,0x4E,0x58,0xDA,0x3F,0xFB,0x4B,0x6C,0x1D,0x6F,0x79,0x7B,
        0x76,0xA1,0x8B,0x6E,0x36,0xAD,0xE6,0x2F,0xF8,0xFD,0x5B,0x32,0x22,0x23,0x0D,0x56,
        0xFD,0xB0,0x38,0x6D,0xF8,0xD1,0xB6,0x1F,0xB1,0x3A,0xEC,0xCB,0x66,0xEF,0x77,0xE5,
        0xF0,0x88,0x7A,0x47,0x6E,0x36,0x15,0xAA,0x49,0xE0,0x6A,0x19,0xF2,0x25,0xB7,0x1B,
        0xEE,0xF4,0x6E,0x6C,0x36,0x0C,0x82,0xA4,0xEA,0x6C,0xBD,0xFB,0xC1,0x1B,0xC8,0x08,
        0x85,0x76,0x42,0x9A,0xA8,0xC5,0xE8,0xC7,0x9B,0x8E,0x23,0x17,0x66,0x9C,0x2D,0x8C,
        0x83,0xD0,0xDD,0x71,0x81,0x0B,0xAE,0xE4,0x05,0xD6,0x5D,0x02,0x79,0x1A,0xE9,0x2E,
        0x17,0x62,0x94,0x7B,0xE3,0x1C,0x72,0x28,0x0B,0xA7,0xD1,0xA8,0xE8,0x6A,0x3D,0x4D,
        0x3F,0x30,0x78,0xF0,0x3D,0x56,0x87,0x7A,0xC8,0x5D,0x95,0xD2,0x68,0xE6,0x4E,0x81,
        0xA5,0xF5,0x00,0x04,0x08,0xB1,0xA9,0x66,0x5E,0xB4,0x65,0xD9,0x39,0x06,0xFC,0x9A,
        0x98,0x0F,0xC3,0x48,0xA1,0xF8,0xF0,0xC0,0xDB,0x1A,0xB3,0x85,0x87,0x9F,0xBF,0x25,
        0x58,0x50,0x03,0xF2,0x6A,0x39,0x45,0x8D,0x87,0x12,0x92,0x88,0xF1,0xAD,0x40,0xC2,
        0x61,0xFA,0x3A,0x58,0x23,0x05,0xDF,0xAC,0x04,0x3F,0x29,0xED,0xFD,0x23,0xDE,0xBE,
        0xF5,0x40,0x81,0xE9,0x02,0x09,0x2F,0x5E,0xCA,0x35,0xC1,0x8F,0x66,0x68,0xCF,0x2D,
        0xDA,0xF1,0x24,0x8C,0x65,0x67,0x01,0x52,0x70,0x57,0xEE,0x2B,0x10,0x58,0x90,0x63,
        0x33,0xD3,0x93,0xB0,0x2C,0x56,0xBF,0x58,0xCB,0xDB,0x8E,0xEE,0x44,0x50,0x45,0x9C,
        0x6F,0xFB,0x12,0x0B,0xFF,0x52,0x59,0x8E,0x3E,0x2E,0x79,0xAB,0x1A,0x04,0x4E,0x71,
        0xA4,0x5D,0x5B,0x93,0xD4,0x1E,0x01,0x83,0x32,0xCC,0xC1,0x89,0xD8,0x13,0x0D,0x20,
        0x11,0x51,0xBB,0x15,0x45,0x84,0x64,0xE0,0x7A,0x05,0x71,0xFD,0xDD,0x13,0x3D,0xC6,
        0x8D,0x1C,0x49,0xE7,0xF4,0xB2,0xC8,0x50,0xF9,0x8F,0xD9,0x33,0x91,0xD0,0xB5,0x2B,
        0x20,0x59,0x99,0xC9,0x49,0x39,0x2C,0x20,0xF9,0x7A,0x19,0xCE,0xAC,0x03,0xA6,0x1E,
        0x8F,0xFA,0xFB,0xBB,0xC9,0x26,0x2B,0x5F,0x89,0x6A,0x1B,0xB6,0xAB,0x30,0x4F,0xA9,
        0x4F,0x46,0xDD,0x84,0x79,0x74,0x7D,0x54,0xEF,0x29,0xEE,0x7A,0x99,0xF9,0xA3,0xF6,
        0xE9,0xBA,0xA4,0x96,0xD4,0xF9,0x61,0xF9,0x2D,0x3A,0x3F,0xDE,0x1D,0x76,0x75,0xC8,
        0x2B,0x6F,0x7F,0x66,0x26,0x21,0xA4,0x1B,0x7D,0xA7,0xCB,0xA0,0x38,0xB0,0xC6,0x90,
        0xC6,0x25,0xCC,0xF0,0x8C,0xB9,0xD5,0x56,0xE4,0xE3,0x56,0x3F,0x34,0x9F,0x36,0x79,
        0xB3,0x26,0x4F,0x29,0x7A,0x3D,0xD0,0xC7,0x15,0x89,0x18,0x2C,0x2E,0xC0,0xC1,0x7C,
        0x74,0xAE,0x17,0xF8,0xA9,0x84,0x3B,0x71,0x99,0x29,0x81,0x42,0xCA,0x65,0xE6,0xDE,
        0x71,0x52,0xEC,0x12,0x61,0x9C,0x16,0x89,0x55,0x04,0xDA,0x03,0xA0,0xA8,0x27,0x23,
        0x22,0xD9,0xCB,0x85,0x87,0x3D,0xCF,0x2F,0xEA,0xDD,0x90,0x51,0xBB,0x8D,0xFD,0xB0,
        0xA2,0x3A,0xBB,0xDB,0xD4,0xAF,0x1B,0xD7,0x98,0x8D,0xA3,0xA4,0xAA,0x38,0xD1,0xF1,
        0x01,0x5D,0x20,0xF0,0x9A,0x60,0x56,0x33,0x83,0xBD,0x27,0x84,0x0C,0xC5,0xCD,0xC7,
        0x07,0x2A,0x60,0x65,0xEC,0x4C,0x4F,0x72,0xBE,0xF3,0xED,0xF9,0x99,0x2A,0x84,0xB2,
        0x0B,0x9F,0x50,0x5E,0x6D,0x0C,0x15,0x42,0xE4,0x88,0x57,0x16,0x87,0x96,0xCB,0xD3,
        0xC0,0xDC,0x9D,0x7F,0xD7,0x6C,0x04,0xB4,0x0E,0xAD,0x31,0xA7,0x73,0x5C,0x9A,0x59,
        0x38,0x74,0x79,0x6D,0x75,0x6F,0x5A,0xFA,0x15,0x1D,0x81,0x64,0xF4,0x38,0xEA,0x28,
        0x27,0x1A,0x39,0xBD,0x8D,0x05,0xDA,0x9F,0x9A,0x9B,0x50,0xBF,0xDB,0x6E,0xCF,0x88,
        0xEE,0xFE,0xDE,0x12,0x1D,0x5E,0x5E,0x51,0x82,0xA2,0x6A,0xB9,0xEB,0xA0,0xBF,0xD5,
        0xC2,0x09,0x7F,0x58,0x22,0xDD,0xCB,0x33,0x9A,0xD9,0xD2,0xD9,0x1E,0x9A,0x1F,0xA6,
        0x4E,0xF9,0x76,0xF5,0x5A,0xD7,0x0A,0xC9,0xBC,0xE7,0x3A,0xEA,0x9A,0x21,0xB4,0xFA,
        0xDC,0x7B,0xFC,0xD1,0xEF,0x76,0x65,0x11,0x32,0xAA,0x78,0x43,0x8C,0x84,0x32,0xE8,
        0x82,0xC3,0x6B,0xF2,0x2A,0xC9,0x7A,0xEA,0xFE,0xB5,0x9C,0x3B,0xA2,0xE1,0x99,0x79,
        0x25,0xD8,0xFD,0xA3,0x9D,0x4E,0xB7,0xD7,0x93,0x65,0xC2,0xB0,0x5F,0xC6,0x3D,0x37,
        0xB4,0x52,0x67,0xD6,0xB5,0xC2,0xD0,0x12,0x00,0x11,0xD2,0x39,0xDA,0x29,0x6E,0x51,
        0x11,0xFF,0x1E,0xB3,0x87,0x8F,0x4A,0x34,0x0C,0x93,0x5E,0xC5,0x06,0xCA,0x8B,0x37,
        0x78,0x65,0x86,0x4F,0x79,0xC2,0xC3,0x63,0x07,0xEB,0xA2,0x8B,0x7B,0x7E,0xFD,0x69,
        0xF6,0x71,0x9E,0x5F,0xA8,0x89,0xB0,0x25,0x07,0x33,0xCA,0x22,0x63,0x0B,0x0B,0x36,
        0x86,0x9A,0xC0,0x74,0xA3,0x1E,0xD7,0x4F,0x3C,0xBB,0xAB,0x9C,0xEC,0xBF,0xB8,0x8D,
        0x95,0xF4,0xCE,0x95,0x2B,0x2C,0x8F,0xEF,0xB4,0x60,0x48,0x46,0xF7,0xA0,0xFF,0xFC,
        0xDF,0x6C,0x05,0xE0,0xBD,0x88,0xC6,0xD7,0x99,0x4F,0x22,0xED,0xDD,0x13,0x38,0x48,
        0x7A,0x3C,0x8D,0x6F,0x3C,0x76,0x0B,0x59,0x0B,0xD1,0xBF,0x43,0xD6,0x91,0x57,0x9B,
        0xBC,0xAF,0xBC,0x80,0xB9,0xD8,0xCF,0x0C,0x2D,0xF7,0xFB,0xDB,0x09,0xA2,0x12,0xA1,
        0x27,0xFF,0xCC,0xBB,0x13,0x8F,0xC0,0x69,0x61,0xAB,0xD5,0xEC,0xC8,0x83,0x00,0x08,
        0xF8,0x87,0x31,0x2E,0x57,0xB8,0x8E,0xA2,0x6C,0x80,0x41,0x45,0x7A,0x2F,0x50,0x69,
        0xBE,0x1E,0x1B,0xD7,0xC5,0x9C,0x88,0x2C,0xEE,0x53,0x1F,0x0E,0x03,0xE2,0x43,0xAA,
        0xF6,0xF2,0xE3,0x82,0x71,0xE3,0x4A,0x6F,0x70,0x2A,0x4E,0x92,0x4D,0x7B,0xEE,0x31,
        0x5B,0x6B,0x2D,0xAA,0x67,0x29,0x43,0x5C,0xFE,0x04,0x3F,0x03,0x98,0x80,0x9E,0x8A,
        0x3D,0x96,0x4E,0x88,0x4B,0xCE,0xF7,0xDB,0xD4,0xAB,0x66,0x9B,0x4E,0xF5,0xDF,0x73,
        0x64,0xED,0xB3,0x97,0xB4,0x99,0x43,0xCC,0xAF,0x87,0x83,0x6D,0xA4,0x46,0xD6,0xF0,
        0x8B,0xC4,0x55,0xB6,0x2C,0x66,0xE6,0x8C,0x74,0x52,0xD5,0xBC,0xC3,0xA8,0x0E,0x09,
        0x25,0xCC,0x9F,0xAA,0xCC,0x07,0xD5,0xA3,0x53,0x82,0xD8,0xC3,0x4A,0x8A,0x37,0x8E,
        0xD4,0x76,0x0F,0x89,0x9F,0x28,0x46,0xFD,0x07,0x26,0x23,0x62,0xC4,0x86,0x09,0x06,
        0x79,0x7A,0x47,0xD7,0xA6,0x2B,0x23,0x83,0xEF,0xB2,0x62,0xAA,0x8D,0x22,0x42,0xE9,
        0x1B,0x46,0xE7,0x4D,0x98,0x84,0x69,0xFC,0x85,0xA1,0xA3,0xA6,0xE4,0x72,0xDF,0xCC,
        0x78,0xD2,0x4A,0xCF,0x43,0x5F,0xE8,0xA8,0x52,0x8B,0x9A,0xED,0xC5,0x9C,0x70,0xE5,
        0xE3,0x3A,0x46,0x7D,0x9F,0xBC,0x6E,0xF5,0x11,0x4B,0x51,0x04,0x88,0x7D,0x9F,0x7C,
        0xD2,0x96,0x31,0xBB,0xD8,0x72,0xA6,0xBC,0x5E,0x3E,0xFA,0x0C,0xE9,0x7B,0x37,0xE9,
        0x31,0xBE,0xC2,0xA9,0x2C,0x62,0x2D,0xBC,0x64,0x54,0xBE,0xF7,0x0D,0xE3,0x20,0xD5,
        0xEC,0x1E,0x1A,0x2F,0x6A,0xB4,0x0C,0x71,0x93,0x89,0x1E,0x60,0xC1,0x61,0x0C,0x95,
        0x13,0x68,0xD3,0xCA,0xBA,0xF5,0x4F,0x70,0x68,0x75,0x57,0x83,0xB4,0xAE,0xAF,0x7B,
        0x1E,0x25,0x20,0xCA,0x61,0x07,0x7F,0x7C,0xB1,0x51,0x16,0xA2,0x43,0xCC,0xFA,0x02,
        0x48,0x29,0xE4,0xA5,0x0F,0x56,0x1A,0xF6,0xCF,0xAA,0xC6,0xF4,0x5D,0x89,0xBC,0xE5,
        0xDA,0xA3,0x42,0x9C,0x41,0x41,0x34,0x0C,0xE8,0x56,0x18,0x69,0xDF,0xAC,0x2C,0x9C,
        0x7A,0x54,0x3A,0x8A,0xCA,0x0A,0x6B,0xC8,0x0A,0x29,0xFB,0xB6,0x41,0x8A,0x1F,0x27,
        0x94,0x30,0xC8,0xA0,0x8A,0x5E,0xC1,0x07,0xF4,0xD8,0xBC,0xB9,0x3D,0xB1,0x16,0x22,
        0x7D,0x2A,0x7A,0x08,0x4E,0x31,0x1B,0xD0,0x37,0x79,0x92,0x17,0x45,0x7D,0xCA,0x5E,
        0x37,0xF0,0xD4,0xAF,0xE4,0x8C,0x11,0x1B,0x93,0x33,0x95,0xF2,0x4D,0xB2,0x8B,0x58,
        0x13,0xD9,0x38,0x17,0x10,0x16,0xD9,0x62,0x14,0xF7,0x69,0x10,0xCC,0xAA,0xC1,0x77,
        0x0D,0x5E,0x81,0x4C,0xDD,0x67,0x3E,0xF1,0x18,0x5E,0x75,0x1B,0x9B,0x29,0x82,0x85,
        0xEE,0x39,0x03,0x6C,0x44,0xB3,0x4D,0x20,0x17,0x71,0x9A,0xEC,0x22,0x00,0x4F,0xE8,
        0x71,0x1E,0xE4,0xEF,0x30,0x3E,0x7A,0xAB,0x9A,0x47,0xFF,0xB1,0xA0,0xBD,0xC6,0xEA,
        0x74,0xE4,0x22,0x92,0xA6,0x55,0x32,0x5A,0x10,0x61,0x34,0x6B,0xCC,0x51,0xCE,0x17,
        0x0E,0x8D,0xAA,0x7D,0x44,0x93,0x54,0xAF,0xBE,0x57,0xD1,0xFD,0xB4,0x9C,0x80,0x5A,
        0xAA,0xAF,0x77,0x3E,0xDE,0xBC,0x41,0x1B,0xEC,0x8A,0xDF,0xCF,0x09,0x0E,0xDF,0x49,
        0x78,0xE7,0xA2,0x13,0x13,0x49,0xA5,0xE1,0x8F,0x73,0xD4,0x4E,0x83,0x34,0xA5,0x74,
        0xE0,0xDA,0xC1,0x1C,0xD9,0x90,0x39,0x52,0x4B,0x8E,0x91,0xBA,0xB4,0x85,0xA5,0xAF,
        0x78,0x88,0x85,0xCC,0xF9,0x6C,0x47,0x61,0x09,0x96,0xAF,0x6B,0xE8,0xF3,0x98,0xB7,
        0xE4,0x6B,0xEE,0x2F,0x4D,0xC3,0x6F,0xE7,0xAE,0x50,0xC8,0x84,0xB8,0xEB,0x2D,0x0A,
        0xCD,0x24,0xD6,0xFB,0xAF,0xD9,0x7A,0x74,0x93,0x5F,0x12,0x43,0xE1,0xCD,0x69,0x57},
        {0},
        /*TST_dataSize*/
        1536*sizeof(DxUint8_t),
        /*TST_Expected_CMAC*/
		{0xF6,0x95,0x6A,0x14,0xE4,0x19,0x18,0x6B,0x88,0x03,0x9F,0xE6,0x76,0x4B,0x8D,0x5A},
        CRYS_AES_CMAC_mode
    } 
};


#if !(TST_USE_AES_16BYTE_DATA|TST_USE_AES_32BYTE_DATA|TST_USE_AES_512BYTE_DATA)
TST_AES_KeyWrap_TestDataStruct SEP_ARS_KeyWrap_Acceptance_TestData[] = {0};
#else
TST_AES_KeyWrap_TestDataStruct SEP_ARS_KeyWrap_Acceptance_TestData[] =
{

	{ 
		{"Acceptance test - AES/KeyWrap/256Key/512ByteData "},
			/*TST_Key*/
		{0x87,0x8d,0x60,0xe6,0x46,0x83,0x22,0xee,0x7b,0x32,0x63,0x83,0xff,0x26,0x50,0xa6,
		0x18,0x94,0x14,0x68,0xe5,0x36,0x59,0x5c,0xfc,0x55,0x0c,0x4c,0x51,0x28,0x61,0x2b},
		CRYS_AES_Key256BitSize,
		/*TST_input_data*/
		{0x8a,0xd5,0x4c,0x91,0xb7,0x94,0x7c,0xfc,0xc4,0xc2,0x38,0x37,0x02,0x79,0x01,0x53,
		0x90,0x6d,0x8c,0xba,0x7e,0x7c,0x0e,0x64,0x32,0x87,0xb7,0x4d,0x0b,0x81,0x7c,0x26,
		0x45,0xc5,0x1a,0x4a,0x1d,0xad,0x58,0xf5,0x35,0x60,0x8c,0xb0,0x39,0xeb,0x60,0x10,
		0xc3,0x94,0xd6,0xa0,0x7c,0x6a,0x8a,0x1c,0x85,0x21,0x38,0xe0,0x15,0x1d,0x7d,0x9f,
		0x63,0xcd,0xe2,0x58,0xc6,0x3a,0x16,0x86,0x1a,0xe0,0x7b,0x98,0x67,0xbc,0xe4,0xa0,
		0xbd,0xa6,0x9e,0x4f,0x62,0xe1,0xad,0x21,0x30,0xf1,0x57,0xd5,0x38,0xac,0xe7,0x20,
		0xab,0x94,0xab,0xa2,0xfb,0x64,0x3f,0x19,0x3d,0xe9,0x0d,0xd5,0xd2,0x13,0x15,0x6c,
		0x46,0x4c,0xea,0xae,0x78,0x08,0xfd,0xdb,0xfb,0x9e,0x1e,0x14,0xbd,0x56,0x40,0x10,
		0xe6,0xc3,0x7d,0x10,0x03,0x53,0x5a,0x15,0x64,0x24,0x4b,0x50,0xc2,0x19,0x7a,0xda,
		0x26,0x2e,0xc4,0xa5,0x05,0x08,0x04,0xb3,0xb0,0xd1,0x95,0x85,0xec,0x42,0x12,0xd7,
		0xdc,0x01,0x60,0x8a,0x28,0x2e,0xef,0xe2,0x58,0x38,0x3c,0xf1,0x81,0xf6,0x9b,0x53,
		0x24,0xf3,0x33,0x1c,0x53,0x09,0x4a,0x0f,0x15,0x31,0xc3,0x11,0x0c,0x99,0xe4,0xdd,
		0x55,0xf7,0x5d,0xf8,0xb0,0x1e,0x86,0xe8,0xe1,0xce,0xe9,0xa1,0x56,0xd1,0x00,0x40,
		0x09,0x43,0x40,0xfb,0xa8,0x32,0x56,0x58,0xf4,0x67,0xb0,0x9e,0x67,0x82,0x3f,0x89,
		0x19,0x4d,0x7b,0x42,0xe4,0x4a,0xa8,0x8e,0xc6,0x8e,0x58,0x46,0x88,0xd2,0x32,0x07,
		0x9d,0xc8,0xf1,0x2a,0x4d,0xab,0xb0,0xf7,0x13,0x1a,0x64,0x15,0x43,0x26,0xaa,0x45,
		0xef,0xaa,0xc3,0x51,0x0c,0xdb,0xdc,0x3e,0xd1,0x1f,0x93,0xc9,0x60,0x23,0xb8,0x12,
		0xa8,0x27,0x50,0x92,0x8a,0x9d,0xe0,0x52,0x3a,0xf3,0xe8,0x5f,0xe9,0xad,0xad,0x79,
		0xa1,0xb6,0x3b,0x0b,0x70,0xf8,0xab,0x60,0xc8,0x2a,0xa2,0x13,0x26,0xe9,0x1a,0xc7,
		0xf2,0x0b,0x65,0x19,0xa6,0x30,0x6e,0xd3,0x33,0x99,0x43,0x62,0xa1,0x3e,0xd0,0x8b,
		0xf5,0x1a,0xed,0x59,0x57,0xca,0x9c,0x5a,0x74,0x56,0x8b,0x0b,0x22,0x4f,0xe1,0x90,
		0x42,0x1a,0x37,0xa8,0xeb,0x8b,0xe3,0xe1,0xc5,0xb6,0x7d,0x08,0xb2,0x01,0x9c,0xe4,
		0xb4,0x7e,0xe1,0x24,0x0b,0x78,0x37,0x95,0x9d,0x4c,0x58,0x98,0x9b,0x7a,0x94,0xd4,
		0x62,0xfc,0xce,0x28,0x9f,0xd7,0xc7,0xe3,0xb7,0xef,0x9f,0x38,0x66,0x1f,0x98,0xec,
		0xa6,0x89,0x1e,0x52,0xd2,0x2b,0x04,0x79,0x0b,0xb4,0x11,0xa4,0xdb,0x95,0xbb,0xfa,
		0x18,0x5a,0x32,0x7f,0x0b,0x3b,0xa0,0x43,0xd2,0xee,0xaf,0xda,0x03,0xc0,0x4d,0x0b,
		0x92,0xe4,0xac,0xcc,0xf5,0x0b,0x8c,0x6f,0x85,0x35,0xbc,0x16,0x28,0xc6,0xde,0x6c,
		0x2d,0xdc,0x6c,0x97,0x77,0xe0,0xf8,0x68,0xde,0x5b,0xb8,0xd5,0xd2,0x0b,0x41,0xaa,
		0x41,0x37,0x93,0x7b,0xbb,0x3f,0x56,0xdd,0xd5,0x77,0x63,0xd6,0xcb,0x35,0x86,0x91,
		0x69,0x29,0x82,0x56,0x2b,0xed,0x56,0xba,0xa3,0xdd,0xbf,0x13,0x1b,0x29,0xfe,0x2f,
		0x7c,0x29,0xdb,0x46,0x6e,0xf0,0xea,0x2c,0xc1,0x23,0x0d,0xcb,0x0c,0x0c,0x3a,0xd1,
		0x93,0xea,0x7f,0xa6,0x6e,0x8b,0x43,0xa1,0xe8,0x1d,0xce,0x7b,0x26,0x42,0x0c,0x04},
		/*TST_InputDataSize*/
		512*sizeof(DxUint8_t),
		/*TST_WrapdData*/
		{0},
		/*TST_WrapdDataSize*/
		(512+TST_KEYWRAP_IV_SIZE_IN_BYTES)*sizeof(DxUint8_t),
		/*TST_Expected_output_data for enc Input data for decrypt*/
		{0xbc,0x6d,0x33,0xdf,0x51,0x7a,0x40,0x91,0x06,0xfd,0x02,0x56,0xf1,0xca,0x31,0x72,
		0x6c,0xf8,0x4d,0x98,0x2c,0xf5,0xef,0xef,0xa2,0xa6,0x64,0x4e,0x34,0xc9,0x02,0x23,
		0xc1,0x88,0x75,0xd1,0xe0,0x15,0x73,0xc3,0xb3,0x78,0x0b,0x97,0xc1,0x01,0xe4,0xac,
		0x99,0x5d,0xca,0x8a,0x32,0xa8,0xef,0x17,0x41,0x38,0x82,0xa0,0x77,0xfb,0xa4,0x77,
		0x06,0x88,0xd2,0xc1,0x31,0x4a,0xd5,0xed,0xcf,0x0f,0x13,0x05,0x93,0xa8,0x94,0xbf,
		0xb7,0x34,0xeb,0x84,0x18,0xe4,0x41,0xb1,0x6e,0x79,0x14,0x5d,0xe6,0x73,0x29,0x6b,
		0x6e,0xe9,0x5d,0x08,0x27,0x98,0xd6,0x4f,0x73,0x43,0x65,0xa7,0x74,0xc5,0x82,0x60,
		0x3d,0x11,0xbe,0x22,0x8b,0xa2,0x5a,0xe9,0x2c,0x83,0xc0,0x1c,0x18,0x0f,0x2d,0x13,
		0x34,0x88,0xd3,0x25,0xae,0xc7,0x02,0x9e,0x2d,0xc7,0xe6,0xc7,0x99,0x51,0xe9,0x78,
		0x2e,0x0b,0x46,0xe1,0x3a,0xeb,0x98,0x64,0x12,0x17,0xf3,0x4c,0x5c,0xf2,0xac,0x40,
		0x7a,0x57,0xe0,0x3d,0x04,0x37,0x4d,0xa5,0x3c,0x5e,0x37,0x2c,0xbb,0x2a,0x05,0x3a,
		0x33,0x73,0x1c,0x01,0x84,0x01,0xb8,0xc2,0x5e,0xc1,0xd2,0xc0,0x6b,0x8d,0x44,0xd5,
		0xf8,0x6f,0xc2,0xf5,0x63,0x67,0xad,0x6f,0x98,0x71,0xa2,0x61,0x1b,0x62,0xdd,0xf8,
		0x9d,0x55,0x54,0xc6,0x43,0xd7,0x26,0xc5,0xb8,0x65,0x79,0xf9,0xef,0xe4,0x9f,0xa2,
		0x4c,0xbc,0xf3,0x63,0x08,0x36,0xba,0x9a,0x13,0x97,0x6b,0xd0,0xe0,0xfd,0x9a,0xfc,
		0x88,0x83,0x56,0x6b,0xcc,0xf4,0x69,0x73,0x1b,0x78,0x87,0x2a,0x40,0xc2,0x90,0x67,
		0xed,0xf6,0x1d,0x66,0xf4,0xed,0xe0,0xb1,0xc6,0x47,0xd3,0x5f,0x1b,0xd2,0x53,0x47,
		0x2d,0x92,0xbc,0xb2,0x95,0x39,0xe3,0x8b,0x68,0x99,0x90,0x29,0x24,0x08,0xc7,0xb4,
		0x26,0x12,0x46,0xe9,0x6a,0x84,0xcc,0x4e,0x7c,0xb1,0x41,0x45,0xb9,0x5d,0x88,0x66,
		0xd4,0x01,0x0f,0x7d,0xdf,0xa7,0x4a,0x9f,0x90,0x57,0x7b,0x6a,0x82,0x29,0x89,0x2e,
		0x5b,0xa2,0xab,0xfc,0xdc,0xa5,0xba,0x72,0x32,0x03,0xa0,0xef,0xce,0x03,0x37,0x7a,
		0x20,0x3f,0x2d,0x11,0xf1,0x9a,0x24,0x9d,0x23,0x2f,0x09,0xe4,0x3b,0xe9,0x85,0xdb,
		0x89,0xb2,0x09,0x63,0x27,0xa2,0xd7,0x19,0xe3,0x60,0x8f,0xd8,0xf5,0xb3,0x22,0x4b,
		0x4f,0x57,0x05,0x0f,0x8e,0x36,0xff,0x63,0x0f,0x0a,0xfe,0x7a,0x16,0xfa,0x95,0x31,
		0x47,0xcb,0xad,0xcc,0x1c,0x51,0xba,0x1f,0x7d,0x48,0xe4,0xb8,0xf7,0x8e,0x49,0x0c,
		0x90,0x48,0x50,0xf9,0xb8,0xb4,0xe5,0xc0,0xb3,0x84,0xde,0x8b,0xb4,0x97,0x4f,0xeb,
		0x1a,0x89,0x1e,0xc8,0xc0,0x94,0x7d,0x01,0xcf,0x0c,0x2c,0x61,0x05,0x10,0x42,0xcb,
		0x29,0x1e,0x1c,0xc3,0x63,0xc3,0xe7,0x1b,0x12,0xf5,0xb5,0xfd,0xbf,0x7a,0xe6,0xa0,
		0x35,0xa4,0xa5,0x51,0x1f,0xb5,0x78,0x00,0x9e,0xa7,0x4e,0x5a,0x15,0xa0,0x57,0x5c,
		0x69,0x2c,0x0d,0x1a,0xf2,0x7c,0x88,0x9a,0x60,0xc1,0x61,0x8e,0x26,0xed,0x8d,0x6d,
		0x7e,0x4b,0x28,0x6e,0xd2,0x58,0xcf,0x32,0x26,0x56,0xbb,0xfa,0x8a,0x86,0x16,0x1d,
		0x33,0xbc,0xff,0xef,0x1d,0xe1,0xd9,0x2f,0x6d,0x85,0xe0,0x07,0x2b,0xd6,0xf4,0x03,
		0xc1,0x05,0x80,0x56,0xa4,0xba,0x18,0x25},       
	}
};
#endif


